#!/usr/bin/python

# Test whether a retained PUBLISH is cleared when a zero length retained
# message is published to a topic.

import subprocess
import socket
import time

import inspect, os, sys
# From http://stackoverflow.com/questions/279237/python-import-a-module-from-a-folder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"..")))
if cmd_subfolder not in sys.path:
    sys.path.insert(0, cmd_subfolder)

import mosq_test

rc = 1
keepalive = 60
connect_packet = mosq_test.gen_connect("retain-clear-test", keepalive=keepalive)
connack_packet = mosq_test.gen_connack(rc=0)

publish_packet = mosq_test.gen_publish("retain/clear/test", qos=0, payload="retained message", retain=True)
retain_clear_packet = mosq_test.gen_publish("retain/clear/test", qos=0, payload=None, retain=True)
mid_sub = 592
subscribe_packet = mosq_test.gen_subscribe(mid_sub, "retain/clear/test", 0)
suback_packet = mosq_test.gen_suback(mid_sub, 0)

mid_unsub = 593
unsubscribe_packet = mosq_test.gen_unsubscribe(mid_unsub, "retain/clear/test")
unsuback_packet = mosq_test.gen_unsuback(mid_unsub)

broker = subprocess.Popen(['../../src/mosquitto', '-p', '1888'], stderr=subprocess.PIPE)

try:
    time.sleep(0.5)

    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(4) # Reduce timeout for when we don't expect incoming data.
    sock.connect(("localhost", 1888))
    sock.send(connect_packet)
    connack_recvd = sock.recv(len(connack_packet))

    if mosq_test.packet_matches("connack", connack_recvd, connack_packet):
        # Send retained message
        sock.send(publish_packet)
        # Subscribe to topic, we should get the retained message back.
        sock.send(subscribe_packet)
        suback_recvd = sock.recv(len(suback_packet))

        if mosq_test.packet_matches("suback", suback_recvd, suback_packet):
            publish_recvd = sock.recv(len(publish_packet))

            if mosq_test.packet_matches("publish", publish_recvd, publish_packet):
                # Now unsubscribe from the topic before we clear the retained
                # message.
                sock.send(unsubscribe_packet)
                unsuback_recvd = sock.recv(len(unsuback_packet))

                if mosq_test.packet_matches("unsuback", unsuback_recvd, unsuback_packet):
                    # Now clear the retained message.
                    sock.send(retain_clear_packet)

                    # Subscribe to topic, we shouldn't get anything back apart
                    # from the SUBACK.
                    sock.send(subscribe_packet)
                    suback_recvd = sock.recv(len(suback_packet))
                    if mosq_test.packet_matches("suback", suback_recvd, suback_packet):
                        try:
                            retain_clear = sock.recv(256)
                        except socket.timeout:
                            # This is the expected event
                            rc = 0
                        else:
                            print("FAIL: Received unexpected message.")

    sock.close()
finally:
    broker.terminate()
    broker.wait()
    if rc:
        (stdo, stde) = broker.communicate()
        print(stde)

exit(rc)

